var browserTests = [
["foo[]bar<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>foo[]bar</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>foo[]bar</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><span>foo</span>{}<span>bar</span></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><span>foo</span>{}<span>bar</span></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo[</span><span>]bar</span><p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><span>foo[</span><span>]bar</span></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<span>foo[</span><span>]bar</span><p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><span>foo[</span><span>]bar</span></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[bar]baz<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>foo[bar]baz</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[bar]baz<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>foo[bar]baz</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["foo]bar[baz<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>foo[bar]baz</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo]bar[baz<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>foo[bar]baz</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["{<p><p> <p>foo</p>}",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>{ foo}</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"div"]}],
["{<p><p> <p>foo</p>}",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>{ foo}</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"div"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>foo[bar<i>baz]qoz</i>quz</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>foo[bar<i>baz]qoz</i>quz</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<table><tbody><tr><td>foo</td><td><div>b[a]r</div></td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<table><tbody><tr><td>foo</td><td><div>b[a]r</div></td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<table><tbody><tr><td>foo</td>{<td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<table><tbody><tr><td>foo</td>{<td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<table><tbody><tr>{<td><div>foo</div></td><td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<table><tbody><tr>{<td><div>foo</div></td><td><div>bar</div></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<table><tbody>{<tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr>}</tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<table><tbody>{<tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr>}</tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<table>{<tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody>}</table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<table>{<tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody>}</table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "{<table><tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody></table>}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "{<table><tbody><tr><td><div>foo</div></td><td><div>bar</div></td><td><div>baz</div></td></tr></tbody></table>}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<div>[foobar]</div>",
    [["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"div"]}],
["<blockquote>[foobar]</blockquote>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<blockquote><div>[foobar]</div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<blockquote>[foobar]</blockquote>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<blockquote><div>[foobar]</div></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<h1>[foobar]</h1>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"div"]}],
["<h1>[foobar]</h1>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"div"]}],
["<h2>[foobar]</h2>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h2",false,false,"div"]}],
["<h2>[foobar]</h2>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h2",false,false,"div"]}],
["<h3>[foobar]</h3>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h3",false,false,"div"]}],
["<h3>[foobar]</h3>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h3",false,false,"div"]}],
["<h4>[foobar]</h4>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h4",false,false,"div"]}],
["<h4>[foobar]</h4>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h4",false,false,"div"]}],
["<h5>[foobar]</h5>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h5",false,false,"div"]}],
["<h5>[foobar]</h5>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h5",false,false,"div"]}],
["<h6>[foobar]</h6>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h6",false,false,"div"]}],
["<h6>[foobar]</h6>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h6",false,false,"div"]}],
["<dl><dt>[foo]<dd>bar</dl>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foo]</div><dl><dd>bar</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dt",false,false,"div"]}],
["<dl><dt>[foo]<dd>bar</dl>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foo]</div><dl><dd>bar</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dt",false,false,"div"]}],
["<dl><dt>foo<dd>[bar]</dl>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<dl><dt>foo</dt></dl><div>[bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dd",false,false,"div"]}],
["<dl><dt>foo<dd>[bar]</dl>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<dl><dt>foo</dt></dl><div>[bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dd",false,false,"div"]}],
["<dl><dt>[foo<dd>bar]</dl>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"dt",false,false,"div"]}],
["<dl><dt>[foo<dd>bar]</dl>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"dt",false,false,"div"]}],
["<ol><li>[foobar]</ol>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<ol><li><div>[foobar]</div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ol><li>[foobar]</ol>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<ol><li><div>[foobar]</div></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<ul><li>[foobar]</ul>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<ul><li><div>[foobar]</div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ul><li>[foobar]</ul>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<ul><li><div>[foobar]</div></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<address>[foobar]</address>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"div"]}],
["<address>[foobar]</address>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"div"]}],
["<pre>[foobar]</pre>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"div"]}],
["<pre>[foobar]</pre>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foobar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"div"]}],
["<article>[foobar]</article>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<article><div>[foobar]</div></article>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<article>[foobar]</article>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<article><div>[foobar]</div></article>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<ins>[foobar]</ins>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><ins>[foobar]</ins></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ins>[foobar]</ins>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><ins>[foobar]</ins></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<del>[foobar]</del>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><del>[foobar]</del></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<del>[foobar]</del>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><del>[foobar]</del></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit>[foobar]</quasit>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><quasit>[foobar]</quasit></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit>[foobar]</quasit>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><quasit>[foobar]</quasit></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><quasit style=\"display:block\">[foobar]</quasit></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><quasit style=\"display:block\">[foobar]</quasit></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>foo[]bar</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[]bar<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>foo[]bar</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><span>foo</span>{}<span>bar</span></p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><span>foo</span>{}<span>bar</span></p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo[</span><span>]bar</span><p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><span>foo[</span><span>]bar</span></p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<span>foo[</span><span>]bar</span><p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><span>foo[</span><span>]bar</span></p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[bar]baz<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>foo[bar]baz</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[bar]baz<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>foo[bar]baz</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["foo]bar[baz<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>foo[bar]baz</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo]bar[baz<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>foo[bar]baz</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["{<p><p> <p>foo</p>}",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>{ foo}</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"p"]}],
["{<p><p> <p>foo</p>}",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>{ foo}</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"p"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>foo[bar<i>baz]qoz</i>quz</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["foo[bar<i>baz]qoz</i>quz<p>extra",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>foo[bar<i>baz]qoz</i>quz</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<table><tbody><tr><td>foo</td><td><p>b[a]r</p></td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<table><tbody><tr><td>foo</td><td><p>b[a]r</p></td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<table><tbody><tr><td>foo</td>{<td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<table><tbody><tr><td>foo</td>{<td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<table><tbody><tr>{<td><p>foo</p></td><td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<table><tbody><tr>{<td><p>foo</p></td><td><p>bar</p></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<table><tbody>{<tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr>}</tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<table><tbody>{<tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr>}</tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<table>{<tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody>}</table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<table>{<tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody>}</table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "{<table><tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody></table>}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "{<table><tbody><tr><td><p>foo</p></td><td><p>bar</p></td><td><p>baz</p></td></tr></tbody></table>}",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<blockquote>[foobar]</blockquote>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<blockquote><p>[foobar]</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<blockquote>[foobar]</blockquote>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<blockquote><p>[foobar]</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<h1>[foobar]</h1>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foobar]</h1>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h2>[foobar]</h2>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h2",false,false,"p"]}],
["<h2>[foobar]</h2>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h2",false,false,"p"]}],
["<h3>[foobar]</h3>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h3",false,false,"p"]}],
["<h3>[foobar]</h3>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h3",false,false,"p"]}],
["<h4>[foobar]</h4>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h4",false,false,"p"]}],
["<h4>[foobar]</h4>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h4",false,false,"p"]}],
["<h5>[foobar]</h5>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h5",false,false,"p"]}],
["<h5>[foobar]</h5>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h5",false,false,"p"]}],
["<h6>[foobar]</h6>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h6",false,false,"p"]}],
["<h6>[foobar]</h6>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h6",false,false,"p"]}],
["<dl><dt>[foo]<dd>bar</dl>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo]</p><dl><dd>bar</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dt",false,false,"p"]}],
["<dl><dt>[foo]<dd>bar</dl>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo]</p><dl><dd>bar</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dt",false,false,"p"]}],
["<dl><dt>foo<dd>[bar]</dl>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<dl><dt>foo</dt></dl><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"dd",false,false,"p"]}],
["<dl><dt>foo<dd>[bar]</dl>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<dl><dt>foo</dt></dl><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"dd",false,false,"p"]}],
["<dl><dt>[foo<dd>bar]</dl>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo</p><p>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"dt",false,false,"p"]}],
["<dl><dt>[foo<dd>bar]</dl>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo</p><p>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"dt",false,false,"p"]}],
["<ol><li>[foobar]</ol>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<ol><li><p>[foobar]</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<ol><li>[foobar]</ol>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<ol><li><p>[foobar]</p></li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<ul><li>[foobar]</ul>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<ul><li><p>[foobar]</p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<ul><li>[foobar]</ul>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<ul><li><p>[foobar]</p></li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<address>[foobar]</address>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foobar]</address>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<pre>[foobar]</pre>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foobar]</pre>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<listing>[foobar]</listing>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<listing>[foobar]</listing>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foobar]</xmp>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foobar]</xmp>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<article>[foobar]</article>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<article><p>[foobar]</p></article>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<article>[foobar]</article>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<article><p>[foobar]</p></article>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<ins>[foobar]</ins>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><ins>[foobar]</ins></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<ins>[foobar]</ins>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><ins>[foobar]</ins></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<del>[foobar]</del>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><del>[foobar]</del></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<del>[foobar]</del>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><del>[foobar]</del></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit>[foobar]</quasit>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><quasit>[foobar]</quasit></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit>[foobar]</quasit>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><quasit>[foobar]</quasit></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><quasit style=\"display:block\">[foobar]</quasit></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<quasit style=\"display: block\">[foobar]</quasit>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><quasit style=\"display:block\">[foobar]</quasit></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<blockquote>[foo]</blockquote><p>extra",
    [["formatblock","<blockquote>"]],
    "<blockquote>[foo]</blockquote><p>extra</p>",
    [false],
    {"formatblock":[false,false,"",false,false,""]}],
["<blockquote><p>[foo]<p>bar</blockquote><p>extra",
    [["formatblock","<blockquote>"]],
    "<blockquote><p>[foo]</p><p>bar</p></blockquote><p>extra</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["[foo]<blockquote>bar</blockquote><p>extra",
    [["formatblock","<blockquote>"]],
    "[foo]<blockquote>bar</blockquote><p>extra</p>",
    [false],
    {"formatblock":[false,false,"",false,false,""]}],
["<p>[foo<p>bar]<p>baz",
    [["formatblock","<blockquote>"]],
    "<p>[foo</p><p>bar]</p><p>baz</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<section>[foo]</section>",
    [["formatblock","<blockquote>"]],
    "<section>[foo]</section>",
    [false],
    {"formatblock":[false,false,"",false,false,""]}],
["<section><p>[foo]</section>",
    [["formatblock","<blockquote>"]],
    "<section><p>[foo]</p></section>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<section><hgroup><h1>[foo]</h1><h2>bar</h2></hgroup><p>baz</section>",
    [["formatblock","<blockquote>"]],
    "<section><hgroup><h1>[foo]</h1><h2>bar</h2></hgroup><p>baz</p></section>",
    [false],
    {"formatblock":[false,false,"h1",false,false,"h1"]}],
["<section>[foo]</section>",
    [["formatblock","<article>"]],
    "<section>[foo]</section>",
    [false],
    {"formatblock":[false,false,"",false,false,""]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<address>"]],
    "<address>[foobar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"address"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<address>"]],
    "<address>[foobar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"address"]}],
["<div>[foobar]</div>",
    [["formatblock","<article>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["formatblock","<blockquote>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<dd>"]],
    "<dl><dd>[foobar]</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"dd"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<dd>"]],
    "<dl><dd>[foobar]</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"dd"]}],
["<div>[foobar]</div>",
    [["formatblock","<del>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["formatblock","<dl>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<dt>"]],
    "<dl><dt>[foobar]</dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"dt"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<dt>"]],
    "<dl><dt>[foobar]</dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"dt"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<h1>"]],
    "<h1>[foobar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h1"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<h1>"]],
    "<h1>[foobar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h1"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<h2>"]],
    "<h2>[foobar]</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h2"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<h2>"]],
    "<h2>[foobar]</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h2"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<h3>"]],
    "<h3>[foobar]</h3>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h3"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<h3>"]],
    "<h3>[foobar]</h3>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h3"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<h4>"]],
    "<h4>[foobar]</h4>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h4"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<h4>"]],
    "<h4>[foobar]</h4>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h4"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<h5>"]],
    "<h5>[foobar]</h5>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h5"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<h5>"]],
    "<h5>[foobar]</h5>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h5"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","<h6>"]],
    "<h6>[foobar]</h6>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"h6"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<h6>"]],
    "<h6>[foobar]</h6>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"h6"]}],
["<div>[foobar]</div>",
    [["formatblock","<ins>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["formatblock","<li>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["formatblock","<ol>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","<pre>"]],
    "<pre>[foobar]</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"pre"]}],
["<div>[foobar]</div>",
    [["formatblock","<ul>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<div>[foobar]</div>",
    [["formatblock","<quasit>"]],
    "<div>[foobar]</div>",
    [false],
    {"formatblock":[false,false,"div",false,false,"div"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<address>"]],
    "<address>[foobar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<address>"]],
    "<address>[foobar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foobar]</p>",
    [["formatblock","<article>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<aside>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<blockquote>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<body>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<dd>"]],
    "<dl><dd>[foobar]</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<dd>"]],
    "<dl><dd>[foobar]</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foobar]</p>",
    [["formatblock","<del>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<details>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<dir>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<dl>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<dt>"]],
    "<dl><dt>[foobar]</dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<dt>"]],
    "<dl><dt>[foobar]</dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foobar]</p>",
    [["formatblock","<fieldset>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<figcaption>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<figure>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<footer>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<form>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h1>"]],
    "<h1>[foobar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h1>"]],
    "<h1>[foobar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h2>"]],
    "<h2>[foobar]</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h2>"]],
    "<h2>[foobar]</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h3>"]],
    "<h3>[foobar]</h3>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h3>"]],
    "<h3>[foobar]</h3>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h4>"]],
    "<h4>[foobar]</h4>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h4>"]],
    "<h4>[foobar]</h4>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h5>"]],
    "<h5>[foobar]</h5>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h5>"]],
    "<h5>[foobar]</h5>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h6>"]],
    "<h6>[foobar]</h6>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h6>"]],
    "<h6>[foobar]</h6>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foobar]</p>",
    [["formatblock","<header>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<head>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<hgroup>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<hr>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<html>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<ins>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<li>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<listing>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<menu>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<nav>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<ol>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<plaintext>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<pre>"]],
    "<pre>[foobar]</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foobar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<pre>"]],
    "<pre>[foobar]</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foobar]</p>",
    [["formatblock","<section>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<ul>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<xmp>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foobar]</p>",
    [["formatblock","<quasit>"]],
    "<p>[foobar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<address>"]],
    "<address>[foo<br>bar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<address>"]],
    "<address>[foo<br>bar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<p>bar]",
    [["formatblock","<article>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<aside>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<blockquote>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<body>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<dd>"]],
    "<dl><dd>[foo</dd><dd>bar]</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<dd>"]],
    "<dl><dd>[foo</dd><dd>bar]</dd></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dd"]}],
["<p>[foo<p>bar]",
    [["formatblock","<del>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<details>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<dir>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"div"]}],
["<p>[foo<p>bar]",
    [["formatblock","<dl>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<dt>"]],
    "<dl><dt>[foo</dt><dt>bar]</dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<dt>"]],
    "<dl><dt>[foo</dt><dt>bar]</dt></dl>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"dt"]}],
["<p>[foo<p>bar]",
    [["formatblock","<fieldset>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<figcaption>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<figure>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<footer>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<form>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<h2>"]],
    "<h2>[foo<br>bar]</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<h2>"]],
    "<h2>[foo<br>bar]</h2>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h2"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<h3>"]],
    "<h3>[foo<br>bar]</h3>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<h3>"]],
    "<h3>[foo<br>bar]</h3>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h3"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<h4>"]],
    "<h4>[foo<br>bar]</h4>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<h4>"]],
    "<h4>[foo<br>bar]</h4>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h4"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<h5>"]],
    "<h5>[foo<br>bar]</h5>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<h5>"]],
    "<h5>[foo<br>bar]</h5>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h5"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<h6>"]],
    "<h6>[foo<br>bar]</h6>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<h6>"]],
    "<h6>[foo<br>bar]</h6>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h6"]}],
["<p>[foo<p>bar]",
    [["formatblock","<header>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<head>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<hgroup>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<hr>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<html>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<ins>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<li>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<listing>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<menu>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<nav>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<ol>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<p>"]],
    "<p>[foo</p><p>bar]</p>",
    [true],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<plaintext>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<pre>"]],
    "<pre>[foo<br>bar]</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<pre>"]],
    "<pre>[foo<br>bar]</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<p>bar]",
    [["formatblock","<section>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<ul>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<xmp>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<p>[foo<p>bar]",
    [["formatblock","<quasit>"]],
    "<p>[foo</p><p>bar]</p>",
    [false],
    {"formatblock":[false,false,"p",false,false,"p"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","div"],["formatblock","p"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div>[foobar]</div>",
    [["defaultparagraphseparator","p"],["formatblock","p"]],
    "<p>[foobar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["<ol><li>[foo]<li>bar</ol>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<ol><li><div>[foo]</div></li><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<ol><li>[foo]<li>bar</ol>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<ol><li><div>[foo]</div></li><li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<h1>[foo]<br>bar</h1>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo]</p><h1>bar</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo]<br>bar</h1>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo]</p><h1>bar</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>foo<br>[bar]</h1>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<h1>foo</h1><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>foo<br>[bar]</h1>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<h1>foo</h1><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo<br>bar]</h1>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo<br>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo<br>bar]</h1>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo<br>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"h1",false,false,"p"]}],
["<h1>[foo]<br>bar</h1>",
    [["formatblock","<address>"]],
    "<address>[foo]</address><h1>bar</h1>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"address"]}],
["<h1>foo<br>[bar]</h1>",
    [["formatblock","<address>"]],
    "<h1>foo</h1><address>[bar]</address>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"address"]}],
["<h1>[foo<br>bar]</h1>",
    [["formatblock","<address>"]],
    "<address>[foo<br>bar]</address>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"address"]}],
["<h1>[foo]<br>bar</h1>",
    [["formatblock","<pre>"]],
    "<pre>[foo]</pre><h1>bar</h1>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"pre"]}],
["<h1>foo<br>[bar]</h1>",
    [["formatblock","<pre>"]],
    "<h1>foo</h1><pre>[bar]</pre>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"pre"]}],
["<h1>[foo<br>bar]</h1>",
    [["formatblock","<pre>"]],
    "<pre>[foo<br>bar]</pre>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"pre"]}],
["<h1>[foo]<br>bar</h1>",
    [["formatblock","<h2>"]],
    "<h2>[foo]</h2><h1>bar</h1>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"h2"]}],
["<h1>foo<br>[bar]</h1>",
    [["formatblock","<h2>"]],
    "<h1>foo</h1><h2>[bar]</h2>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"h2"]}],
["<h1>[foo<br>bar]</h1>",
    [["formatblock","<h2>"]],
    "<h2>[foo<br>bar]</h2>",
    [true],
    {"formatblock":[false,false,"h1",false,false,"h2"]}],
["<p>[foo]<br>bar</p>",
    [["formatblock","<h1>"]],
    "<h1>[foo]</h1><p>bar</p>",
    [true],
    {"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>foo<br>[bar]</p>",
    [["formatblock","<h1>"]],
    "<p>foo</p><h1>[bar]</h1>",
    [true],
    {"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<br>bar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo<br>bar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"h1"]}],
["<p>[foo]<br>bar</p>",
    [["formatblock","<address>"]],
    "<address>[foo]</address><p>bar</p>",
    [true],
    {"formatblock":[false,false,"p",false,false,"address"]}],
["<p>foo<br>[bar]</p>",
    [["formatblock","<address>"]],
    "<p>foo</p><address>[bar]</address>",
    [true],
    {"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<br>bar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<address>"]],
    "<address>[foo<br>bar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo<br>bar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<address>"]],
    "<address>[foo<br>bar]</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"address"]}],
["<p>[foo]<br>bar</p>",
    [["formatblock","<pre>"]],
    "<pre>[foo]</pre><p>bar</p>",
    [true],
    {"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>foo<br>[bar]</p>",
    [["formatblock","<pre>"]],
    "<p>foo</p><pre>[bar]</pre>",
    [true],
    {"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<br>bar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<pre>"]],
    "<pre>[foo<br>bar]</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<p>[foo<br>bar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<pre>"]],
    "<pre>[foo<br>bar]</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"p",false,false,"pre"]}],
["<address>[foo]<br>bar</address>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo]</p><address>bar</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo]<br>bar</address>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo]</p><address>bar</address>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>foo<br>[bar]</address>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<address>foo</address><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>foo<br>[bar]</address>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<address>foo</address><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo<br>bar]</address>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo<br>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo<br>bar]</address>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo<br>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"address",false,false,"p"]}],
["<address>[foo]<br>bar</address>",
    [["formatblock","<pre>"]],
    "<pre>[foo]</pre><address>bar</address>",
    [true],
    {"formatblock":[false,false,"address",false,false,"pre"]}],
["<address>foo<br>[bar]</address>",
    [["formatblock","<pre>"]],
    "<address>foo</address><pre>[bar]</pre>",
    [true],
    {"formatblock":[false,false,"address",false,false,"pre"]}],
["<address>[foo<br>bar]</address>",
    [["formatblock","<pre>"]],
    "<pre>[foo<br>bar]</pre>",
    [true],
    {"formatblock":[false,false,"address",false,false,"pre"]}],
["<address>[foo]<br>bar</address>",
    [["formatblock","<h1>"]],
    "<h1>[foo]</h1><address>bar</address>",
    [true],
    {"formatblock":[false,false,"address",false,false,"h1"]}],
["<address>foo<br>[bar]</address>",
    [["formatblock","<h1>"]],
    "<address>foo</address><h1>[bar]</h1>",
    [true],
    {"formatblock":[false,false,"address",false,false,"h1"]}],
["<address>[foo<br>bar]</address>",
    [["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true],
    {"formatblock":[false,false,"address",false,false,"h1"]}],
["<pre>[foo]<br>bar</pre>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo]</p><pre>bar</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo]<br>bar</pre>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo]</p><pre>bar</pre>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>foo<br>[bar]</pre>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<pre>foo</pre><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>foo<br>[bar]</pre>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<pre>foo</pre><p>[bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo<br>bar]</pre>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo<br>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo<br>bar]</pre>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo<br>bar]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"pre",false,false,"p"]}],
["<pre>[foo]<br>bar</pre>",
    [["formatblock","<address>"]],
    "<address>[foo]</address><pre>bar</pre>",
    [true],
    {"formatblock":[false,false,"pre",false,false,"address"]}],
["<pre>foo<br>[bar]</pre>",
    [["formatblock","<address>"]],
    "<pre>foo</pre><address>[bar]</address>",
    [true],
    {"formatblock":[false,false,"pre",false,false,"address"]}],
["<pre>[foo<br>bar]</pre>",
    [["formatblock","<address>"]],
    "<address>[foo<br>bar]</address>",
    [true],
    {"formatblock":[false,false,"pre",false,false,"address"]}],
["<pre>[foo]<br>bar</pre>",
    [["formatblock","<h1>"]],
    "<h1>[foo]</h1><pre>bar</pre>",
    [true],
    {"formatblock":[false,false,"pre",false,false,"h1"]}],
["<pre>foo<br>[bar]</pre>",
    [["formatblock","<h1>"]],
    "<pre>foo</pre><h1>[bar]</h1>",
    [true],
    {"formatblock":[false,false,"pre",false,false,"h1"]}],
["<pre>[foo<br>bar]</pre>",
    [["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true],
    {"formatblock":[false,false,"pre",false,false,"h1"]}],
["<p>[foo</p>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"p",false,false,"h1"]}],
["<p>[foo</p>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"p",false,false,"h1"]}],
["[foo<p>bar]</p>",
    [["defaultparagraphseparator","div"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"",false,false,"h1"]}],
["[foo<p>bar]</p>",
    [["defaultparagraphseparator","p"],["formatblock","<h1>"]],
    "<h1>[foo<br>bar]</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"",false,false,"h1"]}],
["<div>[foo<p>bar]</p></div>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<div><p>[foo</p><p>bar]</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"",false,false,"p"]}],
["<div>[foo<p>bar]</p></div>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<div><p>[foo</p><p>bar]</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"",false,false,"p"]}],
["<xmp>[foo]</xmp>",
    [["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p>[foo]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foo]</xmp>",
    [["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p>[foo]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"p"]}],
["<xmp>[foo]</xmp>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foo]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<xmp>[foo]</xmp>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foo]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><ol><li>[foo]</ol></div>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><ol><li><div>[foo]</div></li></ol></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><ol><li>[foo]</ol></div>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><ol><li><div>[foo]</div></li></ol></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><table><tr><td>[foo]</table></div>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div><table><tbody><tr><td><div>[foo]</div></td></tr></tbody></table></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"",false,false,"div"]}],
["<div><table><tr><td>[foo]</table></div>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div><table><tbody><tr><td><div>[foo]</div></td></tr></tbody></table></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"",false,false,"div"]}],
["<p>[foo<h1>bar]</h1>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"p",false,false,"div"]}],
["<p>[foo<h1>bar]</h1>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"p",false,false,"div"]}],
["<h1>[foo</h1><h2>bar]</h2>",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"h1",false,false,"div"]}],
["<h1>[foo</h1><h2>bar]</h2>",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"h1",false,false,"div"]}],
["<div>[foo</div>bar]",
    [["defaultparagraphseparator","div"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"div",false,false,"div"]}],
["<div>[foo</div>bar]",
    [["defaultparagraphseparator","p"],["formatblock","<div>"]],
    "<div>[foo</div><div>bar]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"div",false,false,"div"]}],
["<div style=color:blue>[foo]</div>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo]</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div style=color:blue>[foo]</div>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["formatblock","<p>"]],
    "<p><font color=\"#0000ff\">[foo]</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div style=color:blue>[foo]</div>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><span style=\"color:rgb(0, 0, 255)\">[foo]</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["<div style=color:blue>[foo]</div>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["formatblock","<p>"]],
    "<p><font color=\"#0000ff\">[foo]</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"formatblock":[false,false,"div",false,false,"p"]}],
["{<p>foo</p>ba]r",
    [["defaultparagraphseparator","div"],["formatblock","<h1>"]],
    "<h1>{foo<br>ba]r</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"formatblock":[true,false,"p",false,false,"h1"]}],
["{<p>foo</p>ba]r",
    [["defaultparagraphseparator","p"],["formatblock","<h1>"]],
    "<h1>{foo<br>ba]r</h1>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"formatblock":[true,false,"p",false,false,"h1"]}]
]
